set terminal postscript eps enhanced color solid 'Times' 24 linewidth 2
h=6.626070040e-34
c=299792458
k=1.38064852e-23
T=6000
A=2e10
I(x)=2*h*x**3/c**2*A/(exp(h*x/(k*T))-1)
fit I(x) 'planck.dat' using 1:2 via A
fit I(x) 'planck.dat' using 1:2 via A,T
fit I(x) 'planck.dat' using 1:2:3 via A,T
set output 'planck.eps'
set xlabel '{/Symbol n} [Hz]'
set ylabel 'F_{/Symbol n} [mJy]'
set xtics 2.e14
set xrange [5.0e14:1.6e15]
plot 'planck.dat' w e title '',I(x) title ''

