set terminal postscript eps enhanced color solid 'Times' 24 linewidth 2
h=6.626070040e-34
c=299792458
k=1.38064852e-23
T=6000
A=2e10
I(x)=2*h*x**3/c**2*A/(exp(h*x/(k*T))-1)
fit I(x) 'planck_extinction_corrected__PKS0235+16_2008-09-02_00030880024.dat' using 1:2 via A
fit I(x) 'planck_extinction_corrected__PKS0235+16_2008-09-02_00030880024.dat' using 1:2 via A,T
fit I(x) 'planck_extinction_corrected__PKS0235+16_2008-09-02_00030880024.dat' using 1:2:3 via A,T
set output 'planck_extinction_corrected__PKS0235+16_2008-09-02_00030880024.eps'
set xlabel '{/Symbol n} [Hz]'
set ylabel 'F_{/Symbol n} [{/Symbol m}Jy]'
set title 'PKS0235+16  2008-09-02  00030880024'
set xtics 2.e14
set xrange [5.0e14:1.6e15]
plot 'planck_extinction_corrected__PKS0235+16_2008-09-02_00030880024.dat' w e pt 7 ps 1 title '',I(x) title sprintf("T = %2.0f000 K",T/1000)
! convert -density 150 planck_extinction_corrected__PKS0235+16_2008-09-02_00030880024.eps  -background white -alpha remove  planck_extinction_corrected__PKS0235+16_2008-09-02_00030880024.png

