set terminal postscript eps enhanced color solid 'Times' 24 linewidth 2
h=6.626070040e-34
c=299792458
k=1.38064852e-23
T=6000
A=2e-28
# Frequency form
#I(x)=2*h*x**3/c**2*A/(exp(h*x/(k*T))-1)
# Wavelength form, input wavelength in A
I(x)=2*h*c**2/(x/1e10)**5*A/(exp(h*c/( (x/1e10)*k*T))-1)
fit I(x) 'planck_wavelength_extinction_corrected__PKS0235+16_2008-09-02_00030880024.dat' using 1:2 via A
fit I(x) 'planck_wavelength_extinction_corrected__PKS0235+16_2008-09-02_00030880024.dat' using 1:2 via A,T
fit I(x) 'planck_wavelength_extinction_corrected__PKS0235+16_2008-09-02_00030880024.dat' using 1:2:3 via A,T
set output 'planck_wavelength_extinction_corrected__PKS0235+16_2008-09-02_00030880024.eps'
set xlabel '{/Symbol l} [A]'
set ylabel 'F_{/Symbol l} [erg cm^{-2} s^{-1} A^{-1}]'
set title 'PKS0235+16  2008-09-02  00030880024'
#set xtics 2.e14
#set xrange [5.0e14:1.6e15]
set format y '%g'
plot 'planck_wavelength_extinction_corrected__PKS0235+16_2008-09-02_00030880024.dat' w e pt 7 ps 1 title '',I(x) title sprintf("T = %2.0f000 K",T/1000)
! convert -density 150 planck_wavelength_extinction_corrected__PKS0235+16_2008-09-02_00030880024.eps  -background white -alpha remove  planck_wavelength_extinction_corrected__PKS0235+16_2008-09-02_00030880024.png

